# Lingowl Chat - 多语言沟通助手

## 项目简介

Lingowl Chat — 多语言沟通助手，支持 WhatsApp Web 和 LinkedIn 跨语言沟通。自动翻译、智能回复，安全合规、隐私本地处理，助力企业高效安全触达全球客户。

## 主要功能

### 🌍 核心功能
- **自动翻译** - 实时翻译接收到的外语消息为中文
- **智能回复建议** - 基于公司信息生成双语回复建议
- **语言检测** - 自动识别客户使用的语言（支持40+种语言）
- **快捷短语** - 预设常用回复模板，提高回复效率
- **可编辑回复** - 支持手动编辑和调整回复内容

### 🎯 技术特点
- **AI 驱动** - 使用 DeepSeek API 进行翻译和智能回复生成
- **实时处理** - 监听 WhatsApp 消息变化，自动触发翻译
- **双语显示** - 同时显示客户语言和中文版本
- **通用配置** - 支持所有企业的个性化配置

## 安装和使用

### 1. 安装扩展
1. 下载或克隆此项目
2. 在 Chrome 浏览器中打开 `chrome://extensions/`
3. 开启"开发者模式"
4. 点击"加载已解压的扩展程序"
5. 选择项目文件夹

### 2. 配置设置
1. 点击浏览器工具栏中的 Lingowl Chat 图标
2. 输入您的 DeepSeek API Key（从 [DeepSeek 平台](https://platform.deepseek.com/) 获取）
3. 填写公司名称和业务描述
4. 配置快捷短语（可选）
5. 点击"保存设置"

### 3. 开始使用
1. 打开 [WhatsApp Web](https://web.whatsapp.com/)
2. 扩展会自动检测新消息并进行翻译
3. 查看智能回复建议
4. 使用快捷短语提高回复效率

## 配置说明

### API 配置
- **DeepSeek API Key**: 从 DeepSeek 平台获取，用于翻译和智能回复
- **公司名称**: 您的公司名称，用于个性化回复
- **公司描述**: 公司业务描述，帮助生成更准确的回复
- **知识库地址**: 可选，指向包含详细公司信息的 JSON 文件

### 知识库配置（可选）
知识库是一个 JSON 文件，包含详细的公司信息，用于生成更准确和个性化的回复。标准格式如下：

```json
{
  "company_profile": {
    "name": "您的公司名称",
    "mission": "公司使命",
    "description": "公司详细描述"
  },
  "core_values": ["价值观1", "价值观2"],
  "business_units": {
    "产品线1": {
      "focus": "产品重点",
      "key_features": ["功能1", "功能2"]
    }
  },
  "communication_tone": {
    "voice": "沟通语调",
    "style": ["风格1", "风格2"]
  },
  "contact_info": {
    "website": "网站地址",
    "support_email": "支持邮箱"
  }
}
```



### 快捷短语配置
支持三个类别的快捷短语：
- **问候语**: 用于开场白和问候
- **产品介绍语**: 用于产品和服务介绍
- **会议邀约语**: 用于安排会议和约谈

## 支持的语言

支持40+种语言的自动检测和翻译，包括：
- 英语 (English)
- 中文 (Chinese)
- 西班牙语 (Spanish)
- 法语 (French)
- 德语 (German)
- 日语 (Japanese)
- 韩语 (Korean)
- 阿拉伯语 (Arabic)
- 印地语 (Hindi)
- 泰语 (Thai)
- 越南语 (Vietnamese)
- 印尼语 (Indonesian)
- 马来语 (Malay)
- 土耳其语 (Turkish)
- 波兰语 (Polish)
- 荷兰语 (Dutch)
- 瑞典语 (Swedish)
- 挪威语 (Norwegian)
- 丹麦语 (Danish)
- 芬兰语 (Finnish)
- 希腊语 (Greek)
- 希伯来语 (Hebrew)
- 捷克语 (Czech)
- 匈牙利语 (Hungarian)
- 罗马尼亚语 (Romanian)
- 保加利亚语 (Bulgarian)
- 克罗地亚语 (Croatian)
- 斯洛伐克语 (Slovak)
- 斯洛文尼亚语 (Slovenian)
- 爱沙尼亚语 (Estonian)
- 拉脱维亚语 (Latvian)
- 立陶宛语 (Lithuanian)
- 乌克兰语 (Ukrainian)
- 白俄罗斯语 (Belarusian)
- 塞尔维亚语 (Serbian)
- 马其顿语 (Macedonian)
- 阿尔巴尼亚语 (Albanian)
- 波斯尼亚语 (Bosnian)
- 黑山语 (Montenegrin)
- 摩尔多瓦语 (Moldovan)

## 项目结构

```
Lingowl Chat v1.5.0.0/
├── manifest.json          # 扩展配置文件
├── background.js          # 后台服务脚本（核心逻辑）
├── content.js            # 内容脚本（页面交互）
├── lib.js               # 公共工具库
├── styles.css           # 样式文件
├── popup/               # 设置页面
│   ├── popup.html      # 设置界面
│   └── popup.js        # 设置逻辑
├── icons/              # 图标资源
│   └── icon128.png
├── test-lingowl-chat.js # 测试脚本
└── README.md           # 说明文档
```

## 开发说明

### 技术栈
- **前端**: HTML5、CSS3、JavaScript ES6+
- **API**: DeepSeek AI、Chrome Extension API
- **存储**: Chrome Storage Sync
- **目标平台**: Chrome/Edge 浏览器

### 版本历史
- **v1.5.0** - 多语言沟通助手版本发布，支持所有企业使用



## 许可证

本项目现开放给所有企业使用。

## 支持

如有问题或建议，请通过以下方式联系：
- 项目 Issues
- 邮件支持

---

**Lingowl Chat** - 让全球企业轻松服务国际客户 🚀
