console.log("[Lingowl Chat] ✅ content.js 已加载 v1.5.0.0");

// ======= 工具函数 =======
const uid = () => "id_" + Math.random().toString(36).slice(2, 10);
const processedMessages = new WeakSet();

// ======= 语言图标和标签辅助函数 =======
function getLanguageIcon(language) {
  const languageMap = {
    'english': '🇺🇸',
    'chinese': '🇨🇳', 
    'spanish': '🇪🇸',
    'french': '🇫🇷',
    'german': '🇩🇪',
    'italian': '🇮🇹',
    'portuguese': '🇵🇹',
    'russian': '🇷🇺',
    'japanese': '🇯🇵',
    'korean': '🇰🇷',
    'arabic': '🇸🇦',
    'hindi': '🇮🇳',
    'thai': '🇹🇭',
    'vietnamese': '🇻🇳',
    'indonesian': '🇮🇩',
    'malay': '🇲🇾',
    'turkish': '🇹🇷',
    'polish': '🇵🇱',
    'dutch': '🇳🇱',
    'swedish': '🇸🇪',
    'norwegian': '🇳🇴',
    'danish': '🇩🇰',
    'finnish': '🇫🇮',
    'greek': '🇬🇷',
    'hebrew': '🇮🇱',
    'czech': '🇨🇿',
    'hungarian': '🇭🇺',
    'romanian': '🇷🇴',
    'bulgarian': '🇧🇬',
    'croatian': '🇭🇷',
    'slovak': '🇸🇰',
    'slovenian': '🇸🇮',
    'estonian': '🇪🇪',
    'latvian': '🇱🇻',
    'lithuanian': '🇱🇹',
    'ukrainian': '🇺🇦',
    'belarusian': '🇧🇾',
    'serbian': '🇷🇸',
    'macedonian': '🇲🇰',
    'albanian': '🇦🇱',
    'bosnian': '🇧🇦',
    'montenegrin': '🇲🇪',
    'moldovan': '🇲🇩'
  };
  return languageMap[language?.toLowerCase()] || '🌍';
}

function getLanguageLabel(language) {
  const languageMap = {
    'english': 'English',
    'chinese': '中文',
    'spanish': 'Español',
    'french': 'Français',
    'german': 'Deutsch',
    'italian': 'Italiano',
    'portuguese': 'Português',
    'russian': 'Русский',
    'japanese': '日本語',
    'korean': '한국어',
    'arabic': 'العربية',
    'hindi': 'हिन्दी',
    'thai': 'ไทย',
    'vietnamese': 'Tiếng Việt',
    'indonesian': 'Bahasa Indonesia',
    'malay': 'Bahasa Melayu',
    'turkish': 'Türkçe',
    'polish': 'Polski',
    'dutch': 'Nederlands',
    'swedish': 'Svenska',
    'norwegian': 'Norsk',
    'danish': 'Dansk',
    'finnish': 'Suomi',
    'greek': 'Ελληνικά',
    'hebrew': 'עברית',
    'czech': 'Čeština',
    'hungarian': 'Magyar',
    'romanian': 'Română',
    'bulgarian': 'Български',
    'croatian': 'Hrvatski',
    'slovak': 'Slovenčina',
    'slovenian': 'Slovenščina',
    'estonian': 'Eesti',
    'latvian': 'Latviešu',
    'lithuanian': 'Lietuvių',
    'ukrainian': 'Українська',
    'belarusian': 'Беларуская',
    'serbian': 'Српски',
    'macedonian': 'Македонски',
    'albanian': 'Shqip',
    'bosnian': 'Bosanski',
    'montenegrin': 'Crnogorski',
    'moldovan': 'Moldovenească'
  };
  return languageMap[language?.toLowerCase()] || 'Foreign';
}

// ======= 渲染翻译内容 =======
function renderTranslation(container, translated) {
  if (!container) return;
  const old = container.querySelector(".lingowl-translate");
  if (old) old.remove();

  const div = document.createElement("div");
  div.className = "lingowl-translate";
  div.style.fontSize = "13px";
  div.style.color = "#333";
  div.style.background = "#f5f5f5";
  div.style.padding = "6px 10px";
  div.style.borderRadius = "8px";
  div.style.marginTop = "6px";
  div.style.maxWidth = "90%";
  div.style.whiteSpace = "pre-wrap";
  div.style.userSelect = "text";
  div.style.pointerEvents = "auto";
  div.textContent = "💬 翻译：" + translated;
  container.appendChild(div);
}

// ======= 编辑中文回复功能 =======
function editChineseReply(cnElement, bubble) {
  // 确保正确提取中文文本，移除emoji和空格
  // 如果元素已经被编辑过，需要从data属性获取原始文本
  let originalText;
  if (cnElement.dataset.originalText) {
    originalText = cnElement.dataset.originalText;
  } else {
    originalText = cnElement.textContent.replace(/^🇨🇳\s*中文：\s*/, "").trim();
    // 保存原始文本到data属性
    cnElement.dataset.originalText = originalText;
  }
  console.log("[Lingowl Chat] 编辑中文回复，原始文本:", originalText);
  
  // 创建编辑输入框
  const input = document.createElement("input");
  input.type = "text";
  input.value = originalText;
  input.style.width = "100%";
  input.style.padding = "4px 8px";
  input.style.border = "2px solid #4CAF50";
  input.style.borderRadius = "4px";
  input.style.fontSize = "13px";
  input.style.background = "#fff";
  input.style.outline = "none";
  input.style.boxSizing = "border-box";
  input.style.position = "relative";
  input.style.zIndex = "10";
  input.style.pointerEvents = "auto";
  
  // 创建按钮容器
  const btnContainer = document.createElement("div");
  btnContainer.style.marginTop = "4px";
  btnContainer.style.display = "flex";
  btnContainer.style.gap = "4px";
  btnContainer.style.pointerEvents = "auto";
  
  // 保存按钮
  const saveBtn = document.createElement("button");
  saveBtn.textContent = "保存";
  saveBtn.style.fontSize = "11px";
  saveBtn.style.padding = "2px 6px";
  saveBtn.style.background = "#4CAF50";
  saveBtn.style.color = "white";
  saveBtn.style.border = "none";
  saveBtn.style.borderRadius = "3px";
  saveBtn.style.cursor = "pointer";
  
  // 取消按钮
  const cancelBtn = document.createElement("button");
  cancelBtn.textContent = "取消";
  cancelBtn.style.fontSize = "11px";
  cancelBtn.style.padding = "2px 6px";
  cancelBtn.style.background = "#f44336";
  cancelBtn.style.color = "white";
  cancelBtn.style.border = "none";
  cancelBtn.style.borderRadius = "3px";
  cancelBtn.style.cursor = "pointer";
  
  // 替换原内容
  cnElement.innerHTML = "";
  cnElement.appendChild(input);
  cnElement.appendChild(btnContainer);
  btnContainer.appendChild(saveBtn);
  btnContainer.appendChild(cancelBtn);
  
  // 确保输入框能获得焦点
  input.addEventListener("click", (e) => {
    e.stopPropagation();
    input.focus();
  });
  
  // 延迟聚焦，确保DOM更新完成
  setTimeout(() => {
    input.focus();
    input.select();
  }, 10);
  
  // 添加额外的焦点处理
  input.addEventListener("mousedown", (e) => {
    e.stopPropagation();
  });
  
  input.addEventListener("focus", (e) => {
    e.stopPropagation();
  });
  
  // 保存功能
  saveBtn.addEventListener("click", async (e) => {
    e.stopPropagation();
    const newText = input.value.trim();
    
    if (newText && newText !== originalText) {
      // 更新中文显示
      cnElement.innerHTML = "";
      cnElement.textContent = "🇨🇳 中文：" + newText;
      cnElement.style.cursor = "pointer";
      cnElement.title = "点击修改翻译";
      // 更新原始文本数据
      cnElement.dataset.originalText = newText;
      
      // 重新添加点击事件
      cnElement.addEventListener("click", (e) => {
        e.stopPropagation();
        editChineseReply(cnElement, bubble);
      });
      
      // 调用翻译接口更新客户语言回复
      // 从气泡中获取检测到的语言信息
      const foreignElement = bubble.querySelector(".lingowl-reply-foreign");
      const detectedLanguage = foreignElement?.dataset.detectedLanguage || "english";
  console.log("[Lingowl Chat] 🔍 编辑翻译 - 检测到的语言:", detectedLanguage);
  console.log("[Lingowl Chat] 🔍 编辑翻译 - 新文本:", newText);
      await translateAndUpdateForeign(bubble, newText, detectedLanguage);
    } else {
      // 没有变化，恢复原内容
      cnElement.innerHTML = "";
      cnElement.textContent = "🇨🇳 中文：" + originalText;
      cnElement.style.cursor = "pointer";
      cnElement.title = "点击修改翻译";
      cnElement.addEventListener("click", (e) => {
        e.stopPropagation();
        editChineseReply(cnElement, bubble);
      });
    }
  });
  
  // 取消功能
  cancelBtn.addEventListener("click", (e) => {
    e.stopPropagation();
    cnElement.innerHTML = "";
    cnElement.textContent = "🇨🇳 中文：" + originalText;
    cnElement.style.cursor = "pointer";
    cnElement.title = "点击修改翻译";
    cnElement.addEventListener("click", (e) => {
      e.stopPropagation();
      editChineseReply(cnElement, bubble);
    });
  });
  
  // 回车保存，ESC取消
  input.addEventListener("keydown", (e) => {
    if (e.key === "Enter") {
      saveBtn.click();
    } else if (e.key === "Escape") {
      cancelBtn.click();
    }
  });
}

// ======= 翻译并更新客户语言回复 =======
async function translateAndUpdateForeign(bubble, chineseText, detectedLanguage) {
  const foreignElement = bubble.querySelector(".lingowl-reply-foreign");
  if (!foreignElement) return;
  
  console.log("[Lingowl Chat] 🔄 开始翻译 - 中文文本:", chineseText);
  console.log("[Lingowl Chat] 🔄 开始翻译 - 目标语言:", detectedLanguage);
  
  // 显示翻译中状态
  const originalText = foreignElement.textContent;
  foreignElement.textContent = "🌍 翻译中...";
  foreignElement.style.color = "#666";
  
  try {
    // 调用翻译接口，翻译到客户语言
    const response = await new Promise((resolve, reject) => {
      chrome.runtime.sendMessage({
        type: "TRANSLATE_TO_FOREIGN",
        text: chineseText,
        targetLanguage: detectedLanguage
      }, (response) => {
        if (chrome.runtime.lastError) {
          reject(chrome.runtime.lastError);
        } else {
          resolve(response);
        }
      });
    });
    
    console.log("[Lingowl Chat] 📥 翻译响应:", response);
    
    if (response && response.translated) {
      // 更新客户语言回复，使用检测到的语言信息
      const languageIcon = getLanguageIcon(detectedLanguage);
      const languageLabel = getLanguageLabel(detectedLanguage);
      foreignElement.textContent = `${languageIcon} ${languageLabel}：` + response.translated;
      foreignElement.style.color = "#111";
      
      // 显示成功提示
      showEditSuccessTip();
    } else {
      throw new Error("翻译失败");
    }
  } catch (error) {
    console.error("[Lingowl Chat] 翻译更新失败:", error);
    // 恢复原内容
    foreignElement.textContent = originalText;
    foreignElement.style.color = "#111";
    
    // 显示错误提示
    showEditErrorTip();
  }
}

// ======= 显示编辑成功提示 =======
function showEditSuccessTip() {
  const tip = document.createElement("div");
  tip.textContent = "✅ 中文回复已更新，客户语言翻译完成";
  tip.style.position = "fixed";
  tip.style.bottom = "120px";
  tip.style.left = "20px";
  tip.style.background = "#e8f5e8";
  tip.style.color = "#2e7d32";
  tip.style.padding = "8px 12px";
  tip.style.borderRadius = "6px";
  tip.style.fontSize = "13px";
  tip.style.boxShadow = "0 2px 6px rgba(0,0,0,0.1)";
  tip.style.zIndex = "9999";
  document.body.appendChild(tip);
  setTimeout(() => tip.remove(), 3000);
}

// ======= 显示编辑错误提示 =======
function showEditErrorTip() {
  const tip = document.createElement("div");
  tip.textContent = "❌ 翻译更新失败，请重试";
  tip.style.position = "fixed";
  tip.style.bottom = "120px";
  tip.style.left = "20px";
  tip.style.background = "#ffebee";
  tip.style.color = "#c62828";
  tip.style.padding = "8px 12px";
  tip.style.borderRadius = "6px";
  tip.style.fontSize = "13px";
  tip.style.boxShadow = "0 2px 6px rgba(0,0,0,0.1)";
  tip.style.zIndex = "9999";
  document.body.appendChild(tip);
  setTimeout(() => tip.remove(), 3000);
}

// ======= 渲染双语回复气泡 =======
// ======= 最优回复显示（双语 + 可复制 + 可采纳） =======
function renderReplyBubble(targetContainer, replyForeign, replyCN, detectedLanguage) {
  if (!targetContainer) return;

  let bubble = targetContainer.parentElement.querySelector(".lingowl-reply-bubble");
  if (!bubble) {
    bubble = document.createElement("div");
    bubble.className = "lingowl-reply-bubble";
    bubble.style.background = "#dcf8c6";
    bubble.style.color = "#111";
    bubble.style.margin = "8px 0 8px 60px";
    bubble.style.padding = "8px 12px";
    bubble.style.borderRadius = "12px 12px 0 12px";
    bubble.style.maxWidth = "80%";
    bubble.style.fontSize = "14px";
    bubble.style.whiteSpace = "pre-wrap";
    bubble.style.alignSelf = "flex-end";
    bubble.style.boxShadow = "0 2px 5px rgba(0,0,0,0.1)";
    bubble.style.fontFamily = "system-ui, sans-serif";
    bubble.style.lineHeight = "1.5";
    bubble.style.position = "relative";
    bubble.style.userSelect = "text";
    bubble.style.pointerEvents = "auto";

    const foreign = document.createElement("div");
    foreign.className = "lingowl-reply-foreign";
    foreign.style.marginBottom = "4px";
    
    // 根据检测到的语言显示不同的图标和标签
    const languageIcon = getLanguageIcon(detectedLanguage);
    const languageLabel = getLanguageLabel(detectedLanguage);
    foreign.textContent = `${languageIcon} ${languageLabel}：` + replyForeign;
    // 保存检测到的语言信息，供编辑时使用
    foreign.dataset.detectedLanguage = detectedLanguage;

    const cn = document.createElement("div");
    cn.className = "lingowl-reply-cn";
    cn.style.color = "#333";
    cn.style.fontSize = "13px";
    cn.style.cursor = "pointer";
    cn.style.position = "relative";
    cn.title = "点击修改翻译";
    cn.textContent = "🇨🇳 中文：" + replyCN;
    // 设置原始文本数据
    cn.dataset.originalText = replyCN;
    
    // 添加点击编辑功能
    cn.addEventListener("click", (e) => {
      e.stopPropagation();
      editChineseReply(cn, bubble);
    });

    // 🟢 ===== 按钮区域 =====
// 🟢 ===== 按钮区域 =====
const btnBox = document.createElement("div");
btnBox.style.marginTop = "6px";

// 🟦 "修改"按钮 —— 编辑中文回复
const editBtn = document.createElement("button");
editBtn.textContent = "编辑";
editBtn.title = "修改中文回复内容";
editBtn.style.marginRight = "8px";
editBtn.style.fontSize = "12px";
editBtn.style.color = "#1b5c9e";
editBtn.style.background = "#d6ecff";
editBtn.style.border = "none";
editBtn.style.borderRadius = "4px";
editBtn.style.padding = "2px 6px";
editBtn.style.cursor = "pointer";

editBtn.addEventListener("click", (e) => {
  e.stopPropagation();
  const cnElement = bubble.querySelector(".lingowl-reply-cn");
  if (cnElement) {
    editChineseReply(cnElement, bubble);
  }
});

// ✅ "复制"按钮 —— 仅复制当前显示的外语回复
const copyBtn = document.createElement("button");
copyBtn.textContent = "复制";
copyBtn.title = "复制客户语言版本到剪贴板";
copyBtn.style.marginRight = "8px";
copyBtn.style.fontSize = "12px";
copyBtn.style.color = "#0b5a2a";
copyBtn.style.background = "#c8efda";
copyBtn.style.border = "none";
copyBtn.style.borderRadius = "4px";
copyBtn.style.padding = "2px 6px";
copyBtn.style.cursor = "pointer";

copyBtn.addEventListener("click", async (e) => {
  e.stopPropagation();

  // ✅ 从气泡中取实际显示的外语内容
  const foreignElement = bubble.querySelector(".lingowl-reply-foreign");
  const foreignText = foreignElement?.textContent.replace(/^[^：]*：\s*/, "") || "";

  try {
    await navigator.clipboard.writeText(foreignText);
    copyBtn.textContent = "✅ 已复制";
    setTimeout(() => (copyBtn.textContent = "复制"), 1500);
  } catch {
    copyBtn.textContent = "❌ 复制失败";
    setTimeout(() => (copyBtn.textContent = "复制"), 1500);
  }
});

// 🟦 “采纳”按钮 —— 将当前显示内容追加到输入框
const acceptBtn = document.createElement("button");
acceptBtn.textContent = "采纳";
acceptBtn.title = "将此内容追加到输入框末尾";
acceptBtn.style.fontSize = "12px";
acceptBtn.style.color = "#1b5c9e";
acceptBtn.style.background = "#d6ecff";
acceptBtn.style.border = "none";
acceptBtn.style.borderRadius = "4px";
acceptBtn.style.padding = "2px 6px";
acceptBtn.style.cursor = "pointer";

acceptBtn.addEventListener("click", (e) => {
  e.stopPropagation();

  // ✅ 从气泡中取外语内容
  const foreignElement = bubble.querySelector(".lingowl-reply-foreign");
  const foreignText = foreignElement?.textContent.replace(/^[^：]*：\s*/, "") || "";

  const inputBox = Array.from(
    document.querySelectorAll('div[contenteditable="true"][data-lexical-editor="true"]')
  ).find((el) => {
    const label = el.getAttribute("aria-label") || "";
    return label.includes("发送的消息") || label.includes("Type a message");
  });

  if (inputBox) {
    inputBox.focus();
    document.execCommand("insertText", false, " " + foreignText);
    inputBox.dispatchEvent(new InputEvent("input", { bubbles: true }));

    const tip = document.createElement("div");
    tip.textContent = "✅ 已追加到输入框";
    tip.style.position = "fixed";
    tip.style.bottom = "80px";
    tip.style.left = "20px";
    tip.style.background = "#e0f8e9";
    tip.style.color = "#1b6f3b";
    tip.style.padding = "8px 12px";
    tip.style.borderRadius = "6px";
    tip.style.fontSize = "13px";
    tip.style.boxShadow = "0 2px 6px rgba(0,0,0,0.1)";
    tip.style.zIndex = "9999";
    document.body.appendChild(tip);
    setTimeout(() => tip.remove(), 2000);
  } else {
    alert("⚠️ 未找到输入框，请确认 WhatsApp 页面已加载完毕。");
  }
});

btnBox.appendChild(editBtn);
btnBox.appendChild(copyBtn);
btnBox.appendChild(acceptBtn);
bubble.appendChild(foreign);
bubble.appendChild(cn);
bubble.appendChild(btnBox);


    targetContainer.parentElement.appendChild(bubble);
  } else {
    // 更新现有气泡，使用检测到的语言信息
    const languageIcon = getLanguageIcon(detectedLanguage);
    const languageLabel = getLanguageLabel(detectedLanguage);
    bubble.querySelector(".helport-reply-foreign").textContent = `${languageIcon} ${languageLabel}：` + replyForeign;
    
    const cnElement = bubble.querySelector(".lingowl-reply-cn");
    cnElement.textContent = "🇨🇳 中文：" + replyCN;
    cnElement.style.cursor = "pointer";
    cnElement.title = "点击修改翻译";
    // 设置原始文本数据
    cnElement.dataset.originalText = replyCN;
    
    // 重新添加点击编辑功能
    cnElement.removeEventListener("click", editChineseReply);
    cnElement.addEventListener("click", (e) => {
      e.stopPropagation();
      editChineseReply(cnElement, bubble);
    });
  }
}



// ======= 自动翻译逻辑（含启用检测） =======
function autoTranslate(span) {
  const text = span.innerText?.trim();
  if (!text) return;
  if (processedMessages.has(span)) return;
  processedMessages.add(span);

  // 检查消息方向，只对接收到的消息进行翻译
  const messageRow = span.closest('[role="row"]');
  if (!messageRow) return;
  
  // 检查是否是发送的消息（自己发的）
  const isOutgoingMessage = messageRow.querySelector('.message-out') !== null;
  if (isOutgoingMessage) {
    console.log("[Lingowl Chat] ⚪️ 跳过自己发送的消息:", text);
    return;
  }

  chrome.storage.sync.get({ enable: true }, (cfg) => {
    if (!cfg.enable) {
      console.log("[Lingowl Chat] ⚪️ 已关闭自动翻译，跳过：", text);
      return;
    }

    console.log("[Lingowl Chat] 🚀 触发翻译:", text);
    const id = uid();
    const container = span.closest('[role="row"]') || span.parentElement;
    renderTranslation(container, "翻译中…");

    // 收集最近 5 条消息
    const allMsgs = [...document.querySelectorAll('div[class*="copyable-text"] span, div[class*="selectable-text"]')]
      .map((el) => ({
        role: el.closest('[data-pre-plain-text]')?.innerText?.includes("Lingowl")
          ? "assistant"
          : "user",
        text: el.innerText.trim()
      }))
      .filter((m) => m.text && m.text.length < 500)
      .slice(-5);

    chrome.runtime.sendMessage({ type: "TRANSLATE_TEXT", id, text, context: allMsgs }, () => {});
  });
}

// ======= 接收后台翻译结果 =======
chrome.runtime.onMessage.addListener((msg) => {
  if (msg?.type === "TEXT_TRANSLATION_PARTIAL") {
    const { text, translated } = msg;
    const allSpans = document.querySelectorAll('div[class*="copyable-text"] span, div[class*="selectable-text"]');
    allSpans.forEach((span) => {
      if (span.innerText?.trim() === text) {
        const container = span.closest('[role="row"]') || span.parentElement;
        renderTranslation(container, translated);
      }
    });
    return;
  }
  if (msg?.type === "TEXT_TRANSLATION_DONE") {
    const { text, translated, reply_foreign, reply_cn, detected_language, error } = msg;
    const allSpans = document.querySelectorAll('div[class*="copyable-text"] span, div[class*="selectable-text"]');

    allSpans.forEach((span) => {
      if (span.innerText?.trim() === text) {
        const container = span.closest('[role="row"]') || span.parentElement;

        if (error) {
          renderTranslation(container, `❌ 翻译失败：${error}`);
          return;
        }

        renderTranslation(container, translated);
        if (reply_foreign && reply_cn) {
          console.log("[Lingowl Chat] 🎯 显示双语回复 - 检测语言:", detected_language);
          console.log("[Lingowl Chat] 🎯 显示双语回复 - 外语版本:", reply_foreign);
          console.log("[Lingowl Chat] 🎯 显示双语回复 - 中文版本:", reply_cn);
          renderReplyBubble(container, reply_foreign, reply_cn, detected_language);

          // ❌ 不再自动写入输入框，让客服手动点击"采纳"
        }
      }
    });
    return;
  }
  
});

// ======= 快捷短语悬浮功能 =======
let floatingIcon = null;
let quickPhrasesPanel = null;
let isDragging = false;
let dragOffset = { x: 0, y: 0 };

// 创建悬浮图标
function createFloatingIcon() {
  if (floatingIcon) return floatingIcon;
  
  const icon = document.createElement("div");
  icon.id = "lingowl-floating-icon";
  icon.style.position = "fixed";
  icon.style.right = "20px";
  icon.style.top = "50%";
  icon.style.transform = "translateY(-50%)";
  icon.style.width = "48px";
  icon.style.height = "48px";
  icon.style.background = "#25D366";
  icon.style.borderRadius = "50%";
  icon.style.cursor = "pointer";
  icon.style.zIndex = "10000";
  icon.style.boxShadow = "0 4px 12px rgba(0,0,0,0.15)";
  icon.style.display = "flex";
  icon.style.alignItems = "center";
  icon.style.justifyContent = "center";
  icon.style.fontSize = "20px";
  icon.style.color = "white";
  icon.style.userSelect = "none";
  icon.style.transition = "all 0.3s ease";
  
  // 添加图标
  icon.innerHTML = "⚡";
  
  // 添加拖拽功能
  icon.addEventListener("mousedown", startDrag);
  icon.addEventListener("mouseenter", () => {
    icon.style.transform = "translateY(-50%) scale(1.1)";
  });
  icon.addEventListener("mouseleave", () => {
    if (!isDragging) {
      icon.style.transform = "translateY(-50%) scale(1)";
    }
  });
  
  // 添加点击/悬停显示快捷短语
  icon.addEventListener("click", toggleQuickPhrases);
  icon.addEventListener("mouseenter", showQuickPhrases);
  
  document.body.appendChild(icon);
  floatingIcon = icon;
  return icon;
}

// 开始拖拽
function startDrag(e) {
  isDragging = true;
  const rect = floatingIcon.getBoundingClientRect();
  dragOffset.x = e.clientX - rect.left;
  dragOffset.y = e.clientY - rect.top;
  
  document.addEventListener("mousemove", drag);
  document.addEventListener("mouseup", stopDrag);
  e.preventDefault();
}

// 拖拽中
function drag(e) {
  if (!isDragging) return;
  
  const x = e.clientX - dragOffset.x;
  const y = e.clientY - dragOffset.y;
  
  // 限制在视窗内
  const maxX = window.innerWidth - floatingIcon.offsetWidth;
  const maxY = window.innerHeight - floatingIcon.offsetHeight;
  
  const clampedX = Math.max(0, Math.min(x, maxX));
  const clampedY = Math.max(0, Math.min(y, maxY));
  
  floatingIcon.style.left = clampedX + "px";
  floatingIcon.style.top = clampedY + "px";
  floatingIcon.style.right = "auto";
  floatingIcon.style.transform = "none";
}

// 停止拖拽
function stopDrag() {
  isDragging = false;
  document.removeEventListener("mousemove", drag);
  document.removeEventListener("mouseup", stopDrag);
}

// 创建快捷短语面板
function createQuickPhrasesPanel() {
  if (quickPhrasesPanel) return quickPhrasesPanel;
  
  const panel = document.createElement("div");
  panel.id = "lingowl-quick-phrases-panel";
  panel.style.position = "fixed";
  panel.style.right = "70px";
  panel.style.top = "50%";
  panel.style.transform = "translateY(-50%)";
  panel.style.width = "300px";
  panel.style.maxHeight = "400px";
  panel.style.background = "#fff";
  panel.style.border = "1px solid #ddd";
  panel.style.borderRadius = "12px";
  panel.style.padding = "16px";
  panel.style.boxShadow = "0 8px 24px rgba(0,0,0,0.15)";
  panel.style.fontFamily = "system-ui, sans-serif";
  panel.style.display = "none";
  panel.style.zIndex = "10001";
  panel.style.overflowY = "auto";
  
  document.body.appendChild(panel);
  quickPhrasesPanel = panel;
  return panel;
}

// 显示快捷短语
function showQuickPhrases() {
  console.log("[Lingowl Chat] 📋 显示快捷短语...");
  chrome.storage.sync.get({ 
    quickPhrases: { 
      greeting: ["Hello! How can I help you today?"], 
      product: ["Thank you for your interest in our product. Let me provide you with more details."], 
      meeting: ["I'd like to schedule a meeting with you. When would be convenient for you?"] 
    } 
  }, (cfg) => {
    console.log("[Lingowl Chat] 📋 快捷短语配置:", cfg.quickPhrases);
    const panel = createQuickPhrasesPanel();
    panel.innerHTML = "";
    
    // 创建标题栏
    const header = document.createElement("div");
    header.style.display = "flex";
    header.style.justifyContent = "space-between";
    header.style.alignItems = "center";
    header.style.marginBottom = "12px";
    header.style.paddingBottom = "8px";
    header.style.borderBottom = "1px solid #eee";
    
    const title = document.createElement("div");
    title.textContent = "快捷短语";
    title.style.fontSize = "16px";
    title.style.fontWeight = "bold";
    title.style.color = "#333";
    
    const settingsBtn = document.createElement("button");
    settingsBtn.innerHTML = "⚙️";
    settingsBtn.title = "打开设置";
    settingsBtn.style.background = "none";
    settingsBtn.style.border = "none";
    settingsBtn.style.fontSize = "16px";
    settingsBtn.style.cursor = "pointer";
    settingsBtn.style.padding = "4px";
    settingsBtn.style.borderRadius = "4px";
    settingsBtn.style.transition = "background 0.2s";
    
    settingsBtn.addEventListener("mouseenter", () => {
      settingsBtn.style.background = "#f0f0f0";
    });
    
    settingsBtn.addEventListener("mouseleave", () => {
      settingsBtn.style.background = "none";
    });
    
    settingsBtn.addEventListener("click", () => {
      // 通过消息传递让background script打开设置页面
      chrome.runtime.sendMessage({ type: "OPEN_SETTINGS" });
      hideQuickPhrases();
    });
    
    header.appendChild(title);
    header.appendChild(settingsBtn);
    panel.appendChild(header);
    
    const categories = [
      { key: 'greeting', name: '问候语', color: '#28a745' },
      { key: 'product', name: '产品介绍', color: '#007bff' },
      { key: 'meeting', name: '会议邀约', color: '#ffc107' }
    ];
    
    let hasPhrases = false;
    
    categories.forEach(category => {
      const phrases = cfg.quickPhrases[category.key] || [];
      if (phrases.length === 0) return;
      
      hasPhrases = true;
      
      // 创建分类标题
      const categoryTitle = document.createElement("div");
      categoryTitle.textContent = category.name;
      categoryTitle.style.fontSize = "14px";
      categoryTitle.style.fontWeight = "bold";
      categoryTitle.style.marginBottom = "8px";
      categoryTitle.style.color = category.color;
      categoryTitle.style.borderBottom = `2px solid ${category.color}`;
      categoryTitle.style.paddingBottom = "4px";
      panel.appendChild(categoryTitle);
      
      // 创建短语按钮
      phrases.forEach(phrase => {
        const button = document.createElement("button");
        button.textContent = phrase;
        button.style.width = "100%";
        button.style.margin = "4px 0";
        button.style.padding = "8px 12px";
        button.style.border = "none";
        button.style.borderRadius = "6px";
        button.style.background = category.color;
        button.style.color = "white";
        button.style.fontSize = "12px";
        button.style.cursor = "pointer";
        button.style.transition = "opacity 0.2s";
        button.style.textAlign = "left";
        
        button.addEventListener("mouseenter", () => {
          button.style.opacity = "0.8";
        });
        
        button.addEventListener("mouseleave", () => {
          button.style.opacity = "1";
        });
        
        button.addEventListener("click", () => {
          insertPhraseToInput(phrase);
          hideQuickPhrases();
        });
        
        panel.appendChild(button);
      });
    });
    
    // 如果没有快捷短语，显示提示信息
    if (!hasPhrases) {
      const emptyMessage = document.createElement("div");
      emptyMessage.textContent = "暂无快捷短语，点击设置按钮添加";
      emptyMessage.style.textAlign = "center";
      emptyMessage.style.color = "#666";
      emptyMessage.style.fontSize = "12px";
      emptyMessage.style.padding = "20px";
      panel.appendChild(emptyMessage);
    }
    
    panel.style.display = "block";
  });
}

// 切换快捷短语显示
function toggleQuickPhrases() {
  if (quickPhrasesPanel && quickPhrasesPanel.style.display === "block") {
    hideQuickPhrases();
  } else {
    showQuickPhrases();
  }
}

// 隐藏快捷短语
function hideQuickPhrases() {
  if (quickPhrasesPanel) {
    quickPhrasesPanel.style.display = "none";
  }
}

// 插入短语到输入框 - 使用现有的采纳逻辑
function insertPhraseToInput(text) {
  // 使用content.js中现有的采纳按钮逻辑
  const inputBox = Array.from(
    document.querySelectorAll('div[contenteditable="true"][data-lexical-editor="true"]')
  ).find((el) => {
    const label = el.getAttribute("aria-label") || "";
    return label.includes("发送的消息") || label.includes("Type a message");
  });

  if (inputBox) {
    inputBox.focus();
    document.execCommand("insertText", false, " " + text);
    inputBox.dispatchEvent(new InputEvent("input", { bubbles: true }));
  }
}

// ======= 消息上色 + 自动触发翻译 =======
const OLD_MSG_COLOR = "#9b59b6";
const NEW_MSG_COLOR = "#2ecc71";
const coloredMessages = new WeakSet();

function colorExistingMessages() {
  const oldMsgs = document.querySelectorAll('div[class*="copyable-text"] span, div[class*="selectable-text"]');
  oldMsgs.forEach((span) => {
    if (!coloredMessages.has(span)) {
      // 检查是否是接收到的消息
      const messageRow = span.closest('[role="row"]');
      if (messageRow) {
        const isOutgoingMessage = messageRow.querySelector('.message-out') !== null;
        if (isOutgoingMessage) {
          // 跳过自己发送的消息
          return;
        }
      }
      
      span.style.color = OLD_MSG_COLOR;
      coloredMessages.add(span);
    }
  });
}

function watchNewMessages() {
  const chatRoot = document.querySelector("#app") || document.body;
  if (!chatRoot) {
    setTimeout(watchNewMessages, 1500);
    return;
  }

  const observer = new MutationObserver((mutations) => {
    mutations.forEach((m) => {
      m.addedNodes.forEach((n) => {
        if (!(n instanceof Element)) return;
        n.querySelectorAll?.('div[class*="copyable-text"] span, div[class*="selectable-text"]').forEach((span) => {
          if (!coloredMessages.has(span)) {
            // 检查是否是接收到的消息
            const messageRow = span.closest('[role="row"]');
            if (messageRow) {
              const isOutgoingMessage = messageRow.querySelector('.message-out') !== null;
              if (isOutgoingMessage) {
                // 跳过自己发送的消息，不上色也不翻译
                return;
              }
            }
            
            coloredMessages.add(span);
            span.style.transition = "color 1s ease";
            span.style.color = NEW_MSG_COLOR;

            // ✅ 仅启用状态下触发翻译
            autoTranslate(span);

            setTimeout(() => (span.style.color = OLD_MSG_COLOR), 6000);
          }
        });
      });
    });
  });
  observer.observe(chatRoot, { childList: true, subtree: true });
}

// 初始化悬浮快捷短语
function initFloatingQuickPhrases() {
  console.log("[Lingowl Chat] 🚀 初始化悬浮快捷短语...");
  // 创建悬浮图标
  createFloatingIcon();
  console.log("[Lingowl Chat] ✅ 悬浮图标已创建");
  
  // 监听存储变化，当快捷短语配置更新时重新显示
  chrome.storage.onChanged.addListener((changes, namespace) => {
    if (namespace === 'sync' && changes.quickPhrases) {
      console.log("[Lingowl Chat] 快捷短语配置已更新");
      // 如果面板正在显示，则更新内容
      if (quickPhrasesPanel && quickPhrasesPanel.style.display === "block") {
        showQuickPhrases();
      }
    }
  });
  
  // 点击页面其他地方时隐藏面板
  document.addEventListener("click", (e) => {
    if (quickPhrasesPanel && quickPhrasesPanel.style.display === "block") {
      if (!quickPhrasesPanel.contains(e.target) && !floatingIcon.contains(e.target)) {
        hideQuickPhrases();
      }
    }
  });
}

setTimeout(() => {
  colorExistingMessages();
  watchNewMessages();
  initFloatingQuickPhrases();
  
  console.log("[Lingowl Chat] ✅ 自动翻译 + 双语回复 已启动（关闭状态下不触发）");
}, 2000);
